-- Run this in phpMyAdmin (SQL tab) for your database

CREATE TABLE IF NOT EXISTS app_config (
  id TINYINT PRIMARY KEY,
  version INT NOT NULL DEFAULT 1,
  config_json JSON NOT NULL
);

INSERT INTO app_config (id, version, config_json)
VALUES (1, 1, JSON_OBJECT(
  'isPremiumDefault', true,
  'defaultMethod', 'muslim_world_league',
  'defaultMadhab', 'shafi',
  'offsets', JSON_OBJECT('fajr',0,'dhuhr',0,'asr',0,'maghrib',0,'isha',0),
  'features', JSON_OBJECT('quran',true,'adhkar',true,'qibla',true,'radio',true),
  'defaultRadioUrl', 'https://solrt.net:8010/radio.mp3'
))
ON DUPLICATE KEY UPDATE
  version=VALUES(version),
  config_json=VALUES(config_json);

CREATE TABLE IF NOT EXISTS radio_stations (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  stream_url VARCHAR(500) NOT NULL,
  is_default TINYINT NOT NULL DEFAULT 0,
  is_active TINYINT NOT NULL DEFAULT 1
);

INSERT INTO radio_stations (name, stream_url, is_default, is_active)
VALUES ('Solrt Quran Radio', 'https://solrt.net:8010/radio.mp3', 1, 1);

CREATE TABLE IF NOT EXISTS adhkar_categories (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name_ar VARCHAR(120) NOT NULL,
  sort INT NOT NULL DEFAULT 0,
  is_active TINYINT NOT NULL DEFAULT 1
);

CREATE TABLE IF NOT EXISTS adhkar_items (
  id INT AUTO_INCREMENT PRIMARY KEY,
  category_id INT NOT NULL,
  title_ar VARCHAR(200) NOT NULL,
  text_ar TEXT NOT NULL,
  repeat_count INT NOT NULL DEFAULT 1,
  source VARCHAR(200) NULL,
  sort INT NOT NULL DEFAULT 0,
  is_active TINYINT NOT NULL DEFAULT 1,
  CONSTRAINT fk_adhkar_category FOREIGN KEY (category_id)
    REFERENCES adhkar_categories(id) ON DELETE CASCADE
);

-- Seed one category + one item (edit later in admin panel)
INSERT INTO adhkar_categories (name_ar, sort, is_active) VALUES ('أذكار الصباح', 1, 1);
SET @cat_id = LAST_INSERT_ID();

INSERT INTO adhkar_items (category_id, title_ar, text_ar, repeat_count, source, sort, is_active)
VALUES
(@cat_id, 'سُبْحَانَ الله', 'سُبْحَانَ الله', 33, NULL, 1, 1);
