<?php
declare(strict_types=1);
require __DIR__ . '/inc/bootstrap.php';
require __DIR__ . '/inc/layout.php';
require_login();

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $action = $_POST['action'] ?? '';

  if ($action === 'add') {
    $name = trim((string)($_POST['name'] ?? ''));
    $url  = trim((string)($_POST['stream_url'] ?? ''));
    $is_default = isset($_POST['is_default']) ? 1 : 0;
    $is_active  = isset($_POST['is_active']) ? 1 : 0;

    if ($is_default) db()->exec("UPDATE radio_stations SET is_default=0");
    $stmt = db()->prepare("INSERT INTO radio_stations (name, stream_url, is_default, is_active) VALUES (?,?,?,?)");
    $stmt->execute([$name ?: 'Quran Radio', $url, $is_default, $is_active]);
    $msg = t('add_done');
  }

  if ($action === 'update') {
    $id = (int)($_POST['id'] ?? 0);
    $name = trim((string)($_POST['name'] ?? ''));
    $url  = trim((string)($_POST['stream_url'] ?? ''));
    $is_default = isset($_POST['is_default']) ? 1 : 0;
    $is_active  = isset($_POST['is_active']) ? 1 : 0;

    if ($is_default) db()->exec("UPDATE radio_stations SET is_default=0");
    $stmt = db()->prepare("UPDATE radio_stations SET name=?, stream_url=?, is_default=?, is_active=? WHERE id=?");
    $stmt->execute([$name ?: 'Quran Radio', $url, $is_default, $is_active, $id]);
    $msg = t('save_done');
  }

  if ($action === 'delete') {
    $id = (int)($_POST['id'] ?? 0);
    $stmt = db()->prepare("DELETE FROM radio_stations WHERE id=?");
    $stmt->execute([$id]);
    $msg = t('delete_done');
  }
}

$stations = db()->query("SELECT * FROM radio_stations ORDER BY is_default DESC, id ASC")->fetchAll();

page_header(t('radio'));
?>
<div class="card">
  <h3 style="margin-top:0"><?=h(t('add_station'))?></h3>
  <?php if ($msg): ?><p style="color:#b6ffb6"><?=h($msg)?></p><?php endif; ?>
  <form method="post">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="action" value="add">
    <div class="grid">
      <div>
        <label><?=h(t('name'))?></label>
        <input name="name" value="Quran Radio">
      </div>
      <div>
        <label><?=h(t('stream_url'))?></label>
        <input name="stream_url" required placeholder="https://.../radio.mp3">
      </div>
    </div>
    <div style="height:10px"></div>
    <div class="row">
      <label><input type="checkbox" name="is_default" checked> <?=h(t('default'))?></label>
      <label><input type="checkbox" name="is_active" checked> <?=h(t('active'))?></label>
    </div>
    <div style="height:12px"></div>
    <button class="btn" type="submit"><?=h(t('add'))?></button>
    <p class="muted" style="margin-top:10px"><?=h(t('default_tip'))?></p>
  </form>
</div>

<div class="card">
  <h3 style="margin-top:0"><?=h(t('stations_current'))?></h3>
  <table>
    <thead><tr><th><?=h(t('id'))?></th><th><?=h(t('name'))?></th><th><?=h(t('url'))?></th><th><?=h(t('default'))?></th><th><?=h(t('active'))?></th><th><?=h(t('action'))?></th></tr></thead>
    <tbody>
      <?php foreach ($stations as $s): ?>
        <tr>
          <td><?=h((string)$s['id'])?></td>
          <td>
            <form method="post">
              <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
              <input type="hidden" name="action" value="update">
              <input type="hidden" name="id" value="<?=h((string)$s['id'])?>">
              <input name="name" value="<?=h((string)$s['name'])?>">
          </td>
          <td><input name="stream_url" value="<?=h((string)$s['stream_url'])?>"></td>
          <td style="text-align:center">
            <input type="checkbox" name="is_default" <?=((int)$s['is_default']===1)?'checked':''?>>
          </td>
          <td style="text-align:center">
            <input type="checkbox" name="is_active" <?=((int)$s['is_active']===1)?'checked':''?>>
          </td>
          <td>
              <button class="btn2" type="submit"><?=h(t('update'))?></button>
            </form>
            <form method="post" onsubmit="return confirm('OK?')">
              <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="id" value="<?=h((string)$s['id'])?>">
              <button class="btn2" type="submit"><?=h(t('delete'))?></button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php page_footer(); ?>
