<?php
declare(strict_types=1);
require __DIR__ . '/inc/bootstrap.php';
require __DIR__ . '/inc/layout.php';

if (is_logged_in()) { header('Location: index.php'); exit; }

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $email = trim((string)($_POST['email'] ?? ''));
  $pass  = (string)($_POST['password'] ?? '');

  $stmt = db()->prepare("SELECT id, email, password_hash FROM admins WHERE email=? LIMIT 1");
  $stmt->execute([$email]);
  $u = $stmt->fetch();

  if ($u && password_verify($pass, (string)$u['password_hash'])) {
    session_regenerate_id(true);
    $_SESSION['admin_id'] = (int)$u['id'];
    $_SESSION['admin_email'] = (string)$u['email'];
    header('Location: index.php');
    exit;
  }
  $error = t('invalid_login');
}

page_header(t('login'));
?>
<div class="card" style="max-width:520px;margin:40px auto">
  <h2 style="margin-top:0"><?=h(t('login'))?></h2>
  <?php if ($error): ?><p style="color:#ff9a9a"><?=h($error)?></p><?php endif; ?>
  <form method="post">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <label><?=h(t('email'))?></label>
    <input name="email" type="email" required>
    <div style="height:10px"></div>
    <label><?=h(t('password'))?></label>
    <input name="password" type="password" required>
    <div style="height:14px"></div>
    <button class="btn" type="submit"><?=h(t('enter'))?></button>
    <p class="muted" style="margin-top:14px"><?=h(t('first_time_tip'))?></p>
  </form>
</div>
<?php page_footer(); ?>
