<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

function lang_switch_links(): string {
  $base = strtok($_SERVER['REQUEST_URI'] ?? '', '?') ?: '';
  $q = $_GET;
  $q['lang'] = 'ar';
  $ar = $base . '?' . http_build_query($q);
  $q['lang'] = 'en';
  $en = $base . '?' . http_build_query($q);
  return '<a class="btn2" href="'.h($ar).'">'.h(t('arabic')).'</a> <a class="btn2" href="'.h($en).'">'.h(t('english')).'</a>';
}

function page_header(string $title): void {
  $dir = is_rtl() ? 'rtl' : 'ltr';
  $lang = current_lang();
?>
<!doctype html>
<html lang="<?=h($lang)?>" dir="<?=h($dir)?>">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?=h($title)?> - ipray</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial; background:#0b1220; color:#e7eefc; margin:0}
    a{color:#9cd1ff; text-decoration:none}
    .top{display:flex; gap:12px; align-items:center; padding:14px 18px; background:#0f1a33; border-bottom:1px solid #1d2a4e}
    .wrap{max-width:1100px; margin:18px auto; padding:0 16px}
    .card{background:#101b36; border:1px solid #1d2a4e; border-radius:14px; padding:16px; margin-bottom:14px}
    .grid{display:grid; grid-template-columns: 1fr 1fr; gap:12px}
    @media (max-width:900px){.grid{grid-template-columns:1fr}}
    .btn{background:#2b6fff; color:white; border:0; padding:10px 14px; border-radius:10px; cursor:pointer}
    .btn2{background:#243459; color:#e7eefc; border:1px solid #35507f; padding:10px 14px; border-radius:10px; cursor:pointer}
    input,textarea,select{width:100%; padding:10px; border-radius:10px; border:1px solid #2a3b64; background:#0b1220; color:#e7eefc}
    textarea{min-height:120px}
    table{width:100%; border-collapse:collapse}
    th,td{padding:10px; border-bottom:1px solid #1d2a4e; text-align:<?=is_rtl()?'right':'left'?>; vertical-align:top}
    .muted{opacity:.75}
    .row{display:flex; gap:10px; flex-wrap:wrap; align-items:center}
    .row>*{flex:1}
    .badge{display:inline-block; padding:3px 8px; border-radius:999px; border:1px solid #35507f; font-size:12px}
  </style>
</head>
<body>
  <div class="top">
    <strong><?=h(t('panel_title'))?></strong>
    <span class="muted">— <?=h($title)?></span>

    <div style="margin-inline-start:auto; display:flex; gap:8px; align-items:center; flex-wrap:wrap;">
      <span class="muted"><?=h(t('lang'))?>:</span>
      <?=lang_switch_links()?>
      <?php if (is_logged_in()): ?>
        <a class="btn2" href="index.php"><?=h(t('home'))?></a>
        <a class="btn2" href="radio.php"><?=h(t('radio'))?></a>
        <a class="btn2" href="adhkar.php"><?=h(t('adhkar'))?></a>
        <a class="btn2" href="config.php"><?=h(t('config'))?></a>
        <a class="btn2" href="logout.php"><?=h(t('logout'))?></a>
      <?php endif; ?>
    </div>
  </div>
  <div class="wrap">
<?php }

function page_footer(): void { ?>
  </div>
</body>
</html>
<?php } ?>
