<?php
declare(strict_types=1);

function current_lang(): string {
  if (isset($_GET['lang'])) {
    $l = $_GET['lang'] === 'en' ? 'en' : 'ar';
    $_SESSION['lang'] = $l;
    return $l;
  }
  return $_SESSION['lang'] ?? 'ar';
}

function t(string $key): string {
  $lang = current_lang();
  $dict = [
    'ar' => [
      'panel_title' => 'لوحة إدارة ipray',
      'login' => 'تسجيل الدخول',
      'logout' => 'تسجيل خروج',
      'email' => 'الإيميل',
      'password' => 'كلمة المرور',
      'enter' => 'دخول',
      'invalid_login' => 'بيانات الدخول غير صحيحة',
      'home' => 'الرئيسية',
      'radio' => 'الراديو',
      'adhkar' => 'الأذكار',
      'config' => 'الإعدادات',
      'system_status' => 'حالة النظام',
      'stats' => 'إحصائيات',
      'quick_links' => 'روابط سريعة',
      'config_version' => 'إصدار الإعدادات (config version)',
      'stations' => 'محطات الراديو',
      'cats' => 'أقسام الأذكار',
      'items' => 'عناصر الأذكار',
      'save' => 'حفظ',
      'saved' => 'تم الحفظ',
      'add_station' => 'إضافة محطة',
      'name' => 'الاسم',
      'stream_url' => 'رابط البث (mp3/aac)',
      'default' => 'افتراضي',
      'active' => 'مفعل',
      'action' => 'إجراء',
      'delete' => 'حذف',
      'update' => 'تعديل',
      'add' => 'إضافة',
      'app_settings' => 'إعدادات التطبيق (Remote Config)',
      'json_invalid' => 'JSON غير صالح',
      'tip' => 'نصيحة',
      'tip_text' => 'ارفع Version عند كل تعديل حتى التطبيق يعمل Refresh.',
      'lang' => 'اللغة',
      'arabic' => 'عربي',
      'english' => 'إنجليزي',
      'first_time_tip' => 'إذا هذه أول مرة: أنشئ مستخدم من ملف SQL المرفق ثم غيّر كلمة المرور.',
      'stations_current' => 'المحطات الحالية',
      'add_done' => 'تمت إضافة المحطة',
      'save_done' => 'تم حفظ التعديلات',
      'delete_done' => 'تم الحذف',
      'id' => 'ID',
      'url' => 'الرابط',
      'default_tip' => 'اجعل محطة واحدة افتراضية.',
      'dashboard' => 'لوحة التحكم',
    ],
    'en' => [
      'panel_title' => 'ipray Admin Panel',
      'login' => 'Login',
      'logout' => 'Logout',
      'email' => 'Email',
      'password' => 'Password',
      'enter' => 'Sign in',
      'invalid_login' => 'Invalid credentials',
      'home' => 'Home',
      'radio' => 'Radio',
      'adhkar' => 'Adhkar',
      'config' => 'Settings',
      'system_status' => 'System status',
      'stats' => 'Stats',
      'quick_links' => 'Quick links',
      'config_version' => 'Config version',
      'stations' => 'Radio stations',
      'cats' => 'Adhkar categories',
      'items' => 'Adhkar items',
      'save' => 'Save',
      'saved' => 'Saved',
      'add_station' => 'Add station',
      'name' => 'Name',
      'stream_url' => 'Stream URL (mp3/aac)',
      'default' => 'Default',
      'active' => 'Active',
      'action' => 'Action',
      'delete' => 'Delete',
      'update' => 'Update',
      'add' => 'Add',
      'app_settings' => 'App settings (Remote Config)',
      'json_invalid' => 'Invalid JSON',
      'tip' => 'Tip',
      'tip_text' => 'Increase Version after changes so the app refreshes.',
      'lang' => 'Language',
      'arabic' => 'Arabic',
      'english' => 'English',
      'first_time_tip' => 'First time: create an admin user using the provided SQL, then change the password.',
      'stations_current' => 'Current stations',
      'add_done' => 'Station added',
      'save_done' => 'Saved',
      'delete_done' => 'Deleted',
      'id' => 'ID',
      'url' => 'URL',
      'default_tip' => 'Keep only one default station.',
      'dashboard' => 'Dashboard',
    ],
  ];
  return $dict[$lang][$key] ?? $key;
}

function is_rtl(): bool {
  return current_lang() === 'ar';
}
