<?php
declare(strict_types=1);
require __DIR__ . '/inc/bootstrap.php';
require __DIR__ . '/inc/layout.php';
require_login();

$msg = '';
$err = '';

$row = db()->query("SELECT version, config_json FROM app_config WHERE id=1")->fetch();
$version = (int)$row['version'];
$config_json = (string)$row['config_json'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $version2 = (int)($_POST['version'] ?? $version);
  $json2 = (string)($_POST['config_json'] ?? '');

  $decoded = json_decode($json2, true);
  if (!is_array($decoded)) {
    $err = t('json_invalid');
  } else {
    $stmt = db()->prepare("UPDATE app_config SET version=?, config_json=? WHERE id=1");
    $stmt->execute([$version2, json_encode($decoded, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES)]);
    $msg = t('saved');
    $version = $version2;
    $config_json = json_encode($decoded, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
  }
}

page_header(t('app_settings'));
?>
<div class="card">
  <h3 style="margin-top:0"><?=h(t('app_settings'))?></h3>
  <?php if ($msg): ?><p style="color:#b6ffb6"><?=h($msg)?></p><?php endif; ?>
  <?php if ($err): ?><p style="color:#ff9a9a"><?=h($err)?></p><?php endif; ?>

  <form method="post">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <div class="row">
      <div>
        <label>Version</label>
        <input type="number" name="version" value="<?=h((string)$version)?>" min="1">
      </div>
      <div>
        <span class="muted"><?=h(t('tip'))?>: <?=h(t('tip_text'))?></span>
      </div>
    </div>
    <div style="height:12px"></div>
    <label>config_json</label>
    <textarea name="config_json"><?=h($config_json)?></textarea>
    <div style="height:12px"></div>
    <button class="btn" type="submit"><?=h(t('save'))?></button>
  </form>
</div>
<?php page_footer(); ?>
